/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.architectury.event.EventResult;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.integration.rei.AddREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.EntryWrapper;
import dev.latvian.mods.kubejs.integration.rei.GroupREIEntriesEventJS;
import dev.latvian.mods.kubejs.integration.rei.HideREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.InformationREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.KubeJSAddREIWrapperEvent;
import dev.latvian.mods.kubejs.integration.rei.REIEvents;
import dev.latvian.mods.kubejs.integration.rei.RemoveREICategoryEventJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class KubeJSREIPlugin
implements REIClientPlugin {
    private final Set<CategoryIdentifier<?>> categoriesRemoved = new HashSet();
    private static final Map<EntryType<?>, EntryWrapper> entryWrappers = new HashMap();

    public KubeJSREIPlugin() {
        entryWrappers.clear();
        entryWrappers.put(VanillaEntryTypes.ITEM, o -> {
            List<ItemStack> list;
            if (o instanceof ItemStack) {
                ItemStack is = (ItemStack)o;
                list = List.of(is);
            } else {
                list = IngredientJS.of(o).kjs$getDisplayStacks().toList();
            }
            return EntryIngredients.ofItemStacks(list);
        });
        entryWrappers.put(VanillaEntryTypes.FLUID, o -> EntryIngredients.of((FluidStack)FluidStackJS.of(o).getFluidStack()));
        ((Consumer)KubeJSAddREIWrapperEvent.EVENT.invoker()).accept(entryWrappers::put);
    }

    public double getPriority() {
        return 1.0E7;
    }

    public void registerEntries(EntryRegistry registry) {
        entryWrappers.forEach((type, wrapper) -> REIEvents.ADD.post(type.getId(), new AddREIEventJS(registry, (EntryWrapper)wrapper)));
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        entryWrappers.forEach((type, wrapper) -> {
            BasicFilteringRule filter = FilteringRuleTypeRegistry.getInstance().basic();
            EntryRegistry registry = EntryRegistry.getInstance();
            REIEvents.HIDE.post(type.getId(), new HideREIEventJS(registry, (BasicFilteringRule<?>)filter, (EntryType)UtilsJS.cast(type), (EntryWrapper)wrapper));
        });
    }

    public void registerDisplays(DisplayRegistry registry) {
        REIEvents.INFORMATION.post(new InformationREIEventJS());
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.registerVisibilityPredicate(category -> this.categoriesRemoved.contains(category.getCategoryIdentifier()) ? EventResult.interruptFalse() : EventResult.pass());
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage == ReloadStage.END) {
            this.categoriesRemoved.clear();
            REIEvents.REMOVE_CATEGORIES.post(new RemoveREICategoryEventJS(this.categoriesRemoved));
        }
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        REIEvents.GROUP_ENTRIES.post(new GroupREIEntriesEventJS(registry));
    }

    public static EntryType<?> getTypeOrThrow(ResourceLocation typeId) {
        return Objects.requireNonNull(EntryTypeRegistry.getInstance().get(typeId), "Entry type '%s' not found!".formatted(typeId)).getType();
    }

    public static EntryWrapper getWrapperOrFallback(EntryType<?> type) {
        EntryWrapper wrapper = entryWrappers.get(type);
        if (wrapper != null) {
            return wrapper;
        }
        ConsoleJS.CLIENT.warn("No wrapper found for entry type '%s', trying to fall back to id-based wrapper!".formatted(type.getId()));
        return o -> {
            Set ids = CollectionUtils.mapToSet(ListJS.orSelf(o), o1 -> UtilsJS.getMCID(ScriptType.CLIENT.manager.get().context, o1));
            return EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getType().equals(type)).filter(stack -> ids.contains(stack.getIdentifier())).toList();
        };
    }
}

