/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.architectury.registry.registries.Registrar;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.ClassWrapper;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.mod.util.CountingMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface UtilsWrapper {
    public static MinecraftServer getServer() {
        return UtilsJS.staticServer;
    }

    public static void queueIO(Runnable runnable) {
        UtilsJS.queueIO(runnable);
    }

    public static Random getRandom() {
        return UtilsJS.RANDOM;
    }

    public static Random newRandom(long seed) {
        return new Random(seed);
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static List<?> newList() {
        return new ArrayList();
    }

    public static Map<?, ?> newMap() {
        return new LinkedHashMap();
    }

    public static CountingMap newCountingMap() {
        return new CountingMap();
    }

    public static ResourceLocation id(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation id(ResourceLocation id) {
        return id;
    }

    public static Pattern regex(Object s) {
        Pattern pattern = UtilsJS.parseRegex(s);
        return pattern == null ? Pattern.compile(s.toString()) : pattern;
    }

    public static Pattern regex(String pattern, int flags) {
        return Pattern.compile(pattern, flags);
    }

    public static int parseInt(@Nullable Object object, int def) {
        return UtilsJS.parseInt(object, def);
    }

    public static double parseDouble(@Nullable Object object, double def) {
        return UtilsJS.parseDouble(object, def);
    }

    public static Stat<ResourceLocation> getStat(ResourceLocation id) {
        return Stats.f_12988_.m_12902_((Object)id);
    }

    @Nullable
    public static SoundEvent getSound(ResourceLocation id) {
        return (SoundEvent)KubeJSRegistries.soundEvents().get(id);
    }

    public static Object randomOf(Random random, Collection<Object> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (objects instanceof List) {
            List list = (List)objects;
            return list.get(random.nextInt(objects.size()));
        }
        return new ArrayList<Object>(objects).get(random.nextInt(objects.size()));
    }

    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    public static List<ItemStack> rollChestLoot(ResourceLocation id) {
        return UtilsWrapper.rollChestLoot(id, null);
    }

    public static List<ItemStack> rollChestLoot(ResourceLocation id, @Nullable Entity entity) {
        return UtilsJS.rollChestLoot(id, entity);
    }

    @Nullable
    public static Object copy(@Nullable Object o) {
        return UtilsJS.copy(o);
    }

    public static boolean isWrapped(@Nullable Object o) {
        return o instanceof WrappedJS;
    }

    public static String toTitleCase(String s) {
        return UtilsJS.toTitleCase(s);
    }

    public static ClassWrapper<KubeJSRegistries> getRegistries() {
        return new ClassWrapper<KubeJSRegistries>(KubeJSRegistries.class);
    }

    public static Registrar<?> getRegistry(ResourceLocation id) {
        return Objects.requireNonNull(KubeJSRegistries.genericRegistry(ResourceKey.m_135788_((ResourceLocation)id)), "No builtin or static registry found for %s!".formatted(id));
    }

    public static Collection<ResourceLocation> getRegistryIds(ResourceLocation id) {
        return UtilsWrapper.getRegistry(id).getIds();
    }

    public static <T> Lazy<T> lazy(Supplier<T> supplier) {
        return Lazy.of(supplier);
    }

    public static <T> Lazy<T> expiringLazy(Supplier<T> supplier, long time) {
        return Lazy.of(supplier, time);
    }

    @Nullable
    public static CreativeModeTab findCreativeTab(String id) {
        return UtilsJS.findCreativeTab(id);
    }

    public static CompletableFuture<Void> runAsync(Runnable task) {
        return CompletableFuture.runAsync(task, Util.m_183991_());
    }

    public static CompletableFuture<Object> supplyAsync(Supplier<Object> task) {
        return CompletableFuture.supplyAsync(task, Util.m_183991_());
    }
}

