/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IOpenableScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.LoadingScreen;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public abstract class BaseScreen
extends Panel
implements IOpenableScreen {
    private int mouseX;
    private int mouseY;
    private float partialTicks;
    private boolean refreshWidgets;
    private Window screen;
    private final Screen prevScreen;
    public Panel contextMenu = null;
    public ItemRenderer itemRenderer;
    private long lastClickTime = 0L;

    public BaseScreen() {
        super(null);
        this.setSize(176, 166);
        this.setOnlyRenderWidgetsInside(false);
        this.setOnlyInteractWithWidgetsInside(false);
        this.prevScreen = Minecraft.m_91087_().f_91080_;
    }

    @Override
    public final BaseScreen getGui() {
        return this;
    }

    @Override
    public void alignWidgets() {
    }

    public final void initGui() {
        this.screen = this.parent instanceof BaseScreen ? this.parent.getScreen() : Minecraft.m_91087_().m_91268_();
        if (this.onInit()) {
            super.refreshWidgets();
            this.alignWidgets();
            this.onPostInit();
        }
    }

    public Theme getTheme() {
        return Theme.DEFAULT;
    }

    @Override
    public int getX() {
        return (this.getScreen().m_85445_() - this.width) / 2;
    }

    @Override
    public int getY() {
        return (this.getScreen().m_85446_() - this.height) / 2;
    }

    @Override
    public void setScrollX(double scroll) {
    }

    @Override
    public void setScrollY(double scroll) {
    }

    @Override
    public double getScrollX() {
        return 0.0;
    }

    @Override
    public double getScrollY() {
        return 0.0;
    }

    public boolean onInit() {
        return true;
    }

    protected boolean setFullscreen() {
        if (this.screen == null) {
            return false;
        }
        this.setWidth(this.screen.m_85445_());
        this.setHeight(this.screen.m_85446_());
        return true;
    }

    public void onPostInit() {
    }

    @Nullable
    public Screen getPrevScreen() {
        if (this.prevScreen instanceof ScreenWrapper && ((ScreenWrapper)this.prevScreen).getGui() instanceof LoadingScreen) {
            return ((ScreenWrapper)this.prevScreen).getGui().getPrevScreen();
        }
        if (this.prevScreen instanceof ChatScreen) {
            return null;
        }
        return this.prevScreen;
    }

    @Override
    public final void closeGui(boolean openPrevScreen) {
        double mx = Minecraft.m_91087_().f_91067_.m_91589_();
        double my = Minecraft.m_91087_().f_91067_.m_91594_();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91074_.m_6915_();
            if (mc.f_91080_ == null) {
                mc.m_7440_(true);
            }
        }
        if (openPrevScreen && this.getPrevScreen() != null) {
            mc.m_91152_(this.getPrevScreen());
            GLFW.glfwSetCursorPos((long)this.getScreen().m_85439_(), (double)mx, (double)my);
        }
        this.onClosed();
    }

    public boolean onClosedByKey(Key key) {
        return key.escOrInventory();
    }

    public void onBack() {
        this.closeGui(true);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void updateGui(int mx, int my, float pt) {
        this.mouseX = mx;
        this.mouseY = my;
        this.partialTicks = pt;
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
        this.posX = this.getX();
        this.posY = this.getY();
        if (this.contextMenu != null) {
            if (this.contextMenu instanceof BaseScreen) {
                ((BaseScreen)this.contextMenu).updateGui(mx, my, pt);
            } else {
                this.contextMenu.updateMouseOver(this.mouseX, this.mouseY);
            }
        }
        this.updateMouseOver(this.mouseX, this.mouseY);
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
        this.setOffset(true);
        if (this.contextMenu != null) {
            this.contextMenu.updateMouseOver(mouseX, mouseY);
        } else {
            for (Widget widget : this.widgets) {
                widget.updateMouseOver(mouseX, mouseY);
            }
        }
        this.setOffset(false);
    }

    @Override
    public final void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.draw(matrixStack, theme, x, y, w, h);
    }

    @Override
    public void openContextMenu(@Nullable Panel panel) {
        int px = 0;
        int py = 0;
        if (this.contextMenu != null) {
            px = this.contextMenu.posX;
            py = this.contextMenu.posY;
            this.contextMenu.onClosed();
            this.widgets.remove(this.contextMenu);
        }
        if (panel == null) {
            this.contextMenu = null;
            return;
        }
        int x = this.getX();
        int y = this.getY();
        if (this.contextMenu == null) {
            px = this.getMouseX() - x;
            py = this.getMouseY() - y;
        }
        this.contextMenu = panel;
        this.contextMenu.parent = this;
        this.widgets.add(this.contextMenu);
        this.contextMenu.refreshWidgets();
        px = Math.min(px, this.screen.m_85445_() - this.contextMenu.width - x) - 3;
        py = Math.min(py, this.screen.m_85446_() - this.contextMenu.height - y) - 3;
        this.contextMenu.setPos(px, py);
        if (this.contextMenu instanceof BaseScreen) {
            ((BaseScreen)this.contextMenu).initGui();
        }
    }

    public ContextMenu openContextMenu(List<ContextMenuItem> menu) {
        ContextMenu contextMenu = new ContextMenu(this, menu);
        this.openContextMenu(contextMenu);
        return contextMenu;
    }

    @Override
    public void closeContextMenu() {
        this.openContextMenu((Panel)null);
        this.onInit();
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.closeContextMenu();
        CursorType.set(null);
    }

    @Override
    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawGui(matrixStack, x, y, w, h, WidgetType.NORMAL);
    }

    public boolean drawDefaultBackground(PoseStack matrixStack) {
        return true;
    }

    public void drawForeground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (button == MouseButton.BACK) {
            this.closeGui(true);
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.lastClickTime == 0L) {
            this.lastClickTime = now;
        } else {
            if (now - this.lastClickTime <= 300L && this.mouseDoubleClicked(button)) {
                this.lastClickTime = 0L;
                return true;
            }
            this.lastClickTime = 0L;
        }
        return super.mousePressed(button);
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292) == 1 && key.is(66)) {
            Theme.renderDebugBoxes = !Theme.renderDebugBoxes;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAddMouseOverText() {
        return this.contextMenu == null;
    }

    @Override
    public final void openGui() {
        this.openContextMenu((Panel)null);
        Minecraft.m_91087_().m_91152_((Screen)new ScreenWrapper(this));
    }

    @Override
    public final Window getScreen() {
        if (this.screen == null) {
            return this.parent.getScreen();
        }
        return this.screen;
    }

    @Override
    public final int getMouseX() {
        return this.mouseX;
    }

    @Override
    public final int getMouseY() {
        return this.mouseY;
    }

    @Override
    public final float getPartialTicks() {
        return this.partialTicks;
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget widget) {
        if (widget == this) {
            return this.isMouseOver(this.getX(), this.getY(), this.width, this.height);
        }
        if (this.isMouseOver(widget.getX(), widget.getY(), widget.width, widget.height)) {
            boolean offset = widget.parent.isOffset();
            widget.parent.setOffset(false);
            boolean b = this.isMouseOver(widget.parent);
            widget.parent.setOffset(offset);
            return b;
        }
        return false;
    }

    @Override
    public boolean handleClick(String scheme, String path) {
        return ClientUtils.handleClick(scheme, path);
    }

    public void openYesNoFull(Component title, Component desc, BooleanConsumer callback) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(result -> {
            this.openGui();
            callback.accept(result);
            this.refreshWidgets();
        }, title, desc));
    }

    public final void openYesNo(Component title, Component desc, Runnable callback) {
        this.openYesNoFull(title, desc, result -> {
            if (result) {
                callback.run();
            }
        });
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final ClickEvent clickEvent;
        public final HoverEvent hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, Style s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.m_131182_();
            this.hoverEvent = s.m_131186_();
            this.insertion = s.m_131189_();
        }
    }
}

