/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.collections.WeightedCollection;
import com.teamresourceful.resourcefullib.common.utils.RandomCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.Registry;
import org.jetbrains.annotations.ApiStatus;

public final class CodecExtras {
    @Deprecated(since="1.20", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.20")
    public static <T> Codec<RandomCollection<T>> randomCollection(Codec<T> codec, ToDoubleFunction<T> weighter) {
        return codec.listOf().xmap(set -> RandomCollection.of(set, weighter), collection -> collection.stream().toList());
    }

    public static <T> Codec<WeightedCollection<T>> weightedCollection(Codec<T> codec, ToDoubleFunction<T> weighter) {
        return codec.listOf().xmap(set -> WeightedCollection.of(set, weighter), collection -> collection.stream().toList());
    }

    public static <T> Codec<T> registerId(Registry<T> registry) {
        return Codec.INT.comapFlatMap(value -> {
            Object t = registry.m_7942_(value.intValue());
            if (t == null) {
                return DataResult.error((String)("Unknown registry value: " + value));
            }
            return DataResult.success((Object)t);
        }, arg_0 -> registry.m_7447_(arg_0));
    }

    public static <T> Codec<Set<T>> set(Codec<T> codec) {
        return codec.listOf().xmap(HashSet::new, ArrayList::new);
    }

    public static <T> Codec<Set<T>> linkedSet(Codec<T> codec) {
        return codec.listOf().xmap(LinkedHashSet::new, LinkedList::new);
    }

    public static <T> Codec<T> passthrough(Function<T, JsonElement> encoder, Function<JsonElement, T> decoder) {
        return Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
            Object patt2277$temp = dynamic.getValue();
            if (patt2277$temp instanceof JsonElement) {
                JsonElement jsonElement = (JsonElement)patt2277$temp;
                JsonElement output = CodecExtras.clearNulls(jsonElement);
                if (output == null) {
                    return DataResult.error((String)("Value was null for decoder: " + decoder));
                }
                return DataResult.success(decoder.apply(output));
            }
            return DataResult.error((String)"Value was not an instance of JsonElement");
        }, input -> new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)CodecExtras.clearNulls((JsonElement)encoder.apply(input))));
    }

    public static <S> Codec<S> eitherRight(Codec<Either<S, S>> eitherCodec) {
        return eitherCodec.xmap(e -> e.map(p -> p, p -> p), Either::right);
    }

    public static <S> Codec<S> eitherLeft(Codec<Either<S, S>> eitherCodec) {
        return eitherCodec.xmap(e -> e.map(p -> p, p -> p), Either::left);
    }

    private static JsonElement clearNulls(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            JsonObject newObject = new JsonObject();
            for (String key : object.keySet()) {
                JsonElement element = CodecExtras.clearNulls(object.get(key));
                if (element == null) continue;
                newObject.add(key, element);
            }
            return newObject;
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            JsonArray newArray = new JsonArray();
            for (JsonElement item : array) {
                JsonElement element = CodecExtras.clearNulls(item);
                if (element == null) continue;
                newArray.add(element);
            }
            return newArray;
        }
        return json.isJsonNull() ? null : json;
    }
}

