/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.integration.TOPIntegration;
import sonar.fluxnetworks.data.loot.FluxLootTableProvider;
import sonar.fluxnetworks.data.tags.FluxBlockTagsProvider;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.FMLChannel;
import sonar.fluxnetworks.register.RegistryBlockEntityTypes;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;
import sonar.fluxnetworks.register.RegistryMenuTypes;
import sonar.fluxnetworks.register.RegistryRecipes;
import sonar.fluxnetworks.register.RegistrySounds;

@Mod.EventBusSubscriber(modid="fluxnetworks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Registration {
    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        Channel.sChannel = new FMLChannel();
        event.enqueueWork(() -> ForgeChunkManager.setForcedChunkLoadingCallback((String)"fluxnetworks", (level, helper) -> {
            if (!FluxConfig.enableChunkLoading) {
                helper.getBlockTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)helper).removeAllTickets(arg_0));
                FluxNetworks.LOGGER.info("Removed all chunk loaders because chunk loading is disabled");
            } else {
                int chunks = 0;
                for (Map.Entry entry : helper.getBlockTickets().entrySet()) {
                    BlockEntity patt1835$temp = level.m_7702_((BlockPos)entry.getKey());
                    if (patt1835$temp instanceof TileFluxDevice) {
                        TileFluxDevice e = (TileFluxDevice)patt1835$temp;
                        e.setForcedLoading(true);
                        Pair pair = (Pair)entry.getValue();
                        int count = 0;
                        count += ((LongSet)pair.getFirst()).size();
                        if ((count += ((LongSet)pair.getSecond()).size()) != 1) {
                            FluxNetworks.LOGGER.warn("{} in {} didn't load just one chunk {}", entry.getValue(), (Object)level.m_46472_().m_135782_(), (Object)pair);
                        }
                        chunks += count;
                        continue;
                    }
                    helper.removeAllTickets((BlockPos)entry.getKey());
                }
                FluxNetworks.LOGGER.info("Load {} chunks by {} flux devices in {}", (Object)chunks, (Object)helper.getBlockTickets().size(), (Object)level.m_46472_().m_135782_());
            }
        }));
    }

    @SubscribeEvent
    public static void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("carryon")) {
            InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "fluxnetworks:*");
        }
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPIntegration::new);
        }
    }

    @SubscribeEvent
    public static void gatherData(@Nonnull GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new FluxLootTableProvider(generator));
            generator.m_236039_(true, (DataProvider)new FluxBlockTagsProvider(generator, event.getExistingFileHelper()));
        }
    }

    @SubscribeEvent
    public static void register(@Nonnull RegisterEvent event) {
        event.register(ForgeRegistries.BLOCKS.getRegistryKey(), RegistryBlocks::register);
        event.register(ForgeRegistries.ITEMS.getRegistryKey(), RegistryItems::register);
        event.register(ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey(), RegistryBlockEntityTypes::register);
        event.register(ForgeRegistries.MENU_TYPES.getRegistryKey(), RegistryMenuTypes::register);
        event.register(ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), RegistryRecipes::register);
        event.register(ForgeRegistries.SOUND_EVENTS.getRegistryKey(), RegistrySounds::register);
    }
}

