/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.renderer.LaserIOItemRendererFluid;
import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketGhostSlot;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateCard;
import com.direwolf20.laserio.common.network.packets.PacketUpdateFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CardFluidScreen
extends CardItemScreen {
    public int currentFluidExtractAmt;
    public final int filterStartX;
    public final int filterStartY;
    public final int filterEndX;
    public final int filterEndY;

    public CardFluidScreen(CardItemContainer container, Inventory inv, Component name) {
        super(container, inv, name);
        this.filterStartX = 35;
        this.filterStartY = 16;
        this.filterEndX = 125;
        this.filterEndY = 70;
    }

    @Override
    public void m_7856_() {
        this.currentFluidExtractAmt = CardFluid.getFluidExtractAmt(this.card);
        super.m_7856_();
        Minecraft minecraft = Minecraft.m_91087_();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(minecraft.m_167982_(), minecraft.m_167973_());
        this.f_96542_ = new LaserIOItemRendererFluid(minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors(), blockentitywithoutlevelrenderer, this);
    }

    @Override
    public void addAmtButton() {
        this.buttons.put("amount", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 25, 24, 12, this.currentMode == 0 ? this.currentPriority : this.currentFluidExtractAmt, button -> this.changeAmount(-1)));
    }

    @Override
    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/modeinserter.png"), new ResourceLocation("laserio", "textures/gui/buttons/modeextractor.png"), new ResourceLocation("laserio", "textures/gui/buttons/modestocker.png"), new ResourceLocation("laserio", "textures/gui/buttons/modesensor.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = BaseCard.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            ((NumberButton)((Object)((Object)this.buttons.get("amount")))).setValue(this.currentMode == 0 ? this.currentPriority : this.currentFluidExtractAmt);
            this.modeChange();
        }));
    }

    @Override
    public void changeAmount(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 100;
        }
        if (change < 0) {
            if (this.currentMode == 0) {
                this.currentPriority = (short)Math.max(this.currentPriority + change, -4096);
            } else {
                this.currentFluidExtractAmt = Math.max(this.currentFluidExtractAmt + change, 1);
            }
        } else if (this.currentMode == 0) {
            this.currentPriority = (short)Math.min(this.currentPriority + change, 4096);
        } else {
            this.currentFluidExtractAmt = Math.min(this.currentFluidExtractAmt + change, Math.max(this.container.m_38853_(1).m_7993_().m_41613_() * 2000, 1000));
        }
    }

    @Override
    public boolean filterSlot(int btn) {
        int newMBAmt;
        ItemStack slotStack = this.f_97734_.m_7993_();
        if (!FilterCount.doesItemStackHoldFluids(slotStack)) {
            return super.filterSlot(btn);
        }
        if (slotStack.m_41619_()) {
            return true;
        }
        if (btn == 2) {
            slotStack.m_41764_(0);
            PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_(), 0));
            return true;
        }
        int amt = btn == 0 ? 1 : -1;
        int filterSlot = this.f_97734_.f_40219_ - 2;
        int currentMBAmt = FilterCount.getSlotAmount(this.filter, filterSlot);
        if (Screen.m_96638_()) {
            amt *= 10;
        }
        if (Screen.m_96637_()) {
            amt *= 100;
        }
        if ((newMBAmt = currentMBAmt + amt) < 0) {
            newMBAmt = 0;
        }
        if (newMBAmt > 4096000) {
            newMBAmt = 4096000;
        }
        PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_(), newMBAmt));
        return true;
    }

    @Override
    public void setExtract(NumberButton amountButton, int btn) {
        if (btn == 0) {
            this.changeAmount(1);
        } else if (btn == 1) {
            this.changeAmount(-1);
        }
        amountButton.setValue(this.currentMode == 0 ? this.currentPriority : this.currentFluidExtractAmt);
        amountButton.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    @Override
    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    @Override
    public void saveSettings() {
        if (this.showFilter) {
            PacketHandler.sendToServer(new PacketUpdateFilter(this.isAllowList == 1, this.isCompareNBT == 1));
        }
        PacketHandler.sendToServer(new PacketUpdateCard(this.currentMode, this.currentChannel, this.currentFluidExtractAmt, this.currentPriority, this.currentSneaky, (short)this.currentTicks, this.currentExact, this.currentRegulate, (byte)this.currentRoundRobin, 0, 0, this.currentRedstoneMode, this.currentRedstoneChannel, this.currentAndMode));
    }
}

